--------------------------------------------------------------------
--            SymCACP Script Module island
-- Symmetrical CA Control Panel   symCACPscript-1
-- file for finding crystal islands stats
--  	centre of 9 cell neibourhood set to majority state.
--  	display in separate layar
--  	states for island sizes
--
-- original pattern cells neibouring which are the same state are in the same island
-- linked list of islands each with a linked list of states
-- A cell is an edge of the island if it has any neibours of the other state
-- Stats
--   - Island, no of cells, no of edge cells per neibour count
--------------------------------------------------------------------
--  P. Rendell  08/01/2022
--------------------------------------------------------------------
--  18/05/2022  add ortho island runlength
--              take the bigest island of each state and perform a runlength section. The count changes on the encounter of a state
--              of the other island. Assuming that these two islands form interleaved networks covering the universe then in this way
--              the length will ignore froth and other embedded items and give an idea of feature size.
-- input script data
-- scriptFileData.GEO
-- scriptFileData.RULES
-- scriptFileData.SEEDS
-- scriptFileData.WIDTH
-- scriptFileData.HIGHT
-- scriptFileData.GEN
-- scriptFileData.STEP
-- scriptFileData.COUNT
-- scriptFileData.RESULTS_NEW
-- scriptFileData.RESULTS_OLD
-- scriptFileData.RESULTS_HALF
-- scriptFileData.LOGFILE
-- scriptFileData.SQUARE

--
-- output 1 to RESULTS_NEW
-- RULE, GEO, WIDTH, HIGHT, SEED, GEN, ISLANDSIZE, NUMBER
-- output 2 to RESULTS_HALF
-- RULE,GEO,WV,HV,SEED,GEN,MAXCELLS,NOORTHOISLES,ALLISLES,ALLORTHISLES
-- output 3 to RESULTS_STRIP
-- RULE,GEO, WD, SEED,  STRIPDIR, START_X, START_Y, GEN, DIST, RUNLENG


------------------------------------------------------------

local scriptType = "script2-island"
m={}				-- class table
m.test ="*"
local comProcs			-- common Procedures
local isle_cellScan		-- function
local logFile
local g = golly()
local scriptFileData
local gr = require("buildUni") 
local gt = require("search-band") 
--  "r" = rule, "s" = seed, "d" = decimal "t" = text, "g" = geo
-- "R" = required
m.colonList = {['RULES'] = {"r","R"}, ['SEEDS'] = {"s","R"}}
m.equalList = {['WIDTH'] = {"d","R"}, ['HIGHT'] = {"d",""},
                   ['LOGFILE'] = {'t',""}, ['RESULTS_OLD'] = {'t',""}, ['RESULTS_NEW'] = {'t',"R"}, ['RESULTS_HALF'] = {'t',""},
                   ['STEP'] = {"d","R"}, ['GEN'] = {"d","R"},
                   ['STEP1'] = {"d","R"}, ['RESULTS_STRIP'] = {"t","R"},  ['CELL_X'] = {'d',"R"}, ['CELL_Y'] = {'d',"R"},
                   ['GEO'] = {'g',""}, ['COUNT'] = {'d',"R"} }

------------------------------------------------------------------------------------------------
isleCnt = 0
isleNumber = 0
isleNoMax = 0
isleLstStart = nil
cellIsleNo = {}
scanDoLst = {}
scanMap = {}
cellDicOrtho = {}
muliLstDic = {}
lastStripIsland = 0
nextStripIsland = 0
--cellDic[tostring(iu)..","..tostring(ju)]   if(cellDic[cellkeyU] == isleLst.isleNo) then /replaced by cellIsleNo  --#2023-06-19##
--==============================================================================
--==============================================================================

local function getCurrentIsland(cellI, cellJ, currentIsle, largestIsles)
   local thisIsle = cellDicOrtho[tostring(cellI)..","..tostring(cellJ)]
   local current = currentIsle
   if ((thisIsle == largestIsles[1]) or (thisIsle == largestIsles[2]) ) then
      current = thisIsle 
   end
   res = nil
   if (current ~= nil) then
      res = current
   end
   return (res)
end
--==============================================================================
local function storeLine(outData, dir, h, dist, strip, x, y)
   outData[#outData+1] = string.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n",
            			                h.rule, h.geo, h.width, h.seed, dir, h.x, h.y, h.gen, dist, strip,x,y)
end
--------------------------------------------------------------------------------
local function stripVD(outData,h, dir, largestIsles)
   -- leng is whole universe loop. join ends so that all samples are between state changes
   -- dir 'V', 'D'
   local x = h.x
   local y = h.y
   local dist = 0
   local xyMax = (h.width-1)//2
   g.show("h.width "..(h.width-1)//2)
   g.show("xymax "..xyMax)
   local strip = 1
   local cellKey = tostring(x)..","..tostring(y)
   local lastIsle = cellDicOrtho[cellKey]
   local startLen = 1
   local started = false
   local doneLen = 0
   local currentIsle, xInc, yInc
   if (dir == 'V') then
      xInc = 0
   else
     xInc = 1
   end
   function modXY(v)
      if v > xyMax then
         v = v - h.width
      end
      return v
   end
   while doneLen <= h.width do
      y = modXY(y + 1)
      x = modXY(x + xInc)
      logFile:write("***###x,y "..x..","..y.."\n")
      dist = modXY(dist+1)
      currentIsle = getCurrentIsland(x, y, currentIsle, largestIsles)
      if (currentIsle == nil) then
         h.stripFile:write("stripVD "..h.rule.." isle nill\n")
      end
      if ((currentIsle == nil) or (currentIsle == lastIsle)) then
         strip = strip +1
      elseif (strip > 0) then
         if started then
            storeLine(outData, dir, h, dist, strip, x, y)
         else
            doneLen= 1
            started = true
         end
         strip = 1
      end
      lastIsle = currentIsle
      doneLen = doneLen + 1
   end
   if not started then
            storeLine(outData, dir, h, dist, strip, x, y)
   elseif (strip > 0) then
            storeLine(outData, dir, h, dist, strip, x, y)
   end
end
------------------------------------------------------------

-----------------------------------------------------------------------------------------------
local function init()
   isleCnt = 0
   isleNumber = 0
   isleNoMax = 0
   isleLstStart = nil
   cellIsleNo = {}
   scanDoLst = {}
   scanMap = {}
   cellDicOrtho = {}
   muliLstDic = {}
   m.wv = tonumber(g.getwidth())
   m.hv = tonumber(g.getheight())
   if (type(m.hv) ~=   "number") then
      m.hv = m.wv
   end
   m.i0 = -(m.wv//2)
   m.i1 = m.wv + m.i0 - 1
   m.j0 = -(m.hv//2)
   m.j1 = m.hv + m.j0 - 1
end
-----------------------------------------------------------------------------------------------

local function add2ScanDoLst(cellI, cellJ, cellKey, cellState)
   if (not scanDoLst[cellState]) then
      scanDoLst[cellState] = nil
      logFile:write("#add2ScanDoLst new state "..cellState.." cell "..cellKey.."\n")
   end
   scanDoLst[cellState] = {next = scanDoLst[cellState], ip=cellI, jp=cellJ, cellKey = cellKey, cellState = cellState}
end
-----------------------------------------------------------------------------------------------

local function Isle_GetLargest()
   local iLst = isleLstStart
   local largest = {}
   logFile:write("#Isle_GetLargest 1st state "..iLst.cellState.."\n")
   while (iLst) do
      logFile:write("#Isle_GetLargest  state = "..iLst.cellState.." size "..iLst.Cells.."\n")
      if ( largest[iLst.cellState]) then
         logFile:write("#Isle_GetLargest was  "..largest[iLst.cellState].size.."\n")
      end
      if ( (not largest[iLst.cellState]) or (largest[iLst.cellState].size < iLst.Cells) )  then
         largest[iLst.cellState] = {isleNo = iLst.isleNo, size = iLst.Cells, isle = iLst}
      end
      iLst = iLst.next
   end
   return (largest)
end
-----------------------------------------------------------------------------------------------

local function Isle_New(cellI, cellJ, cellKey, cellState, edgeCount)
   if (cellIsleNo[cellKey]) then
      logFile:write("*** Isle_New attempt "..cellKey.." already in isleNo "..cellIsleNo[cellKey].."\n")
   else
      logFile:write("Isle_New "..cellKey.." state "..cellState.."\n")
      isleNoMax = isleNoMax + 1
      isleCnt = isleCnt + 1
      local lst = isleLstStart
      isleLstStart = {next = isleLstStart, prev = nil, isleNo = isleNoMax, cellState = cellState, 
                      embbeded = false, embbedCnt = 0, diagConCnt = 0, Cells = 1, MaxChecked = false,
                      cellLst = {next = cellLst, cellI = cellI, cellJ = cellJ, edgeCnt = edgeCount}}
      if (lst) then
         lst.prev = isleLstStart
      end
      cellIsleNo[cellKey] = isleLstStart.isleNo
      isle_cellScan(cellI, cellJ, cellKey, cellState, isleLstStart)
   end
   return(isleLstStart)
end

-----------------------------------------------------------------------------------------------

local function isle_ListAddCell(isleLst, cellI, cellJ, cellState, edgeCount)
   local cellKey = cellI..","..cellJ
   logFile:write("isle_ListAddCell  "..cellKey.." to isleNo "..isleLst.isleNo.."\n")
   if (cellIsleNo[cellKey]) then
      logFile:write("*** addCell attempt add "..cellKey.." to isleNo "..isleLst.isleNo.." already in isleNo "..cellIsleNo[cellKey].."\n")
   else
      if (isleLst == nil) then
         logFile:write("*** addCell attempt add to a nil list\n")
      else
         if (isleLst.cellState ~= cellState) then
            logFile:write("*** addCell attempt add cell of the wrong state\n")
         else
            cellIsleNo[cellKey] = isleLstStart.isleNo
            isleLst.cellLst = {next = isleLst.cellLst, cellI = cellI, cellJ = cellJ, edgeCnt = edgeCount}
            isleLst.Cells = isleLst.Cells + 1
         end
      end
   end
end

------------------------------------------------------------
local function cellCoord(i0,i1,i)
   if (i < i0) then
      return(i1)
   elseif (i > i1) then
      return (i0)
   end
   return (i)
end

------------------------------------------------------------
local function NBcount(ip, jp, state)
   local nbCnt = 0
   --logFile:write("NBcount ip,jp "..ip..","..jp.." ip-1 -> "..cellCoord(m.i0,m.i1,ip-1).."\n")
   if (g.getcell(cellCoord(m.i0,m.i1,ip-1), jp) ~= state) then
      nbCnt = nbCnt + 1
   end
   if (g.getcell(cellCoord(m.i0,m.i1,ip+1), jp) ~= state) then
      nbCnt = nbCnt + 1
   end
   if (g.getcell(ip, cellCoord(m.j0,m.j1,jp-1)) ~= state) then
      nbCnt = nbCnt + 1
   end
   if (g.getcell(ip, cellCoord(m.j0,m.j1,jp+1)) ~= state) then
      nbCnt = nbCnt + 1
   end
   return (nbCnt)
end
-----------------------------------------------------------------------------------------------

local function GetLargestIsles()
   logFile:write("GetLargestIsles\n")
   local state0Isle = nil
   local state0IsleState = nil
   local state1Isle = nil
   local iLst = isleLstStart
   while (iLst) do
      local mLst = iLst.MultiCellLst
      if (state0Isle == nil) then
         state0Isle = mLst
         state0IsleState = iLst.cellState
      end
      if (state0IsleState == iLst.cellState) then
         while (mLst) do
            if (state0Isle.Cells < mLst.Cells) then
      	       state0Isle = mLst
            end
	    mLst = mLst.next
         end
      else
         if (state1Isle == nil) then
            state1Isle = mLst
         end
         while (mLst) do
            if (state1Isle.Cells < mLst.Cells) then
      	       state1Isle = mLst
            end
	    mLst = mLst.next
         end
      end
      iLst = iLst.next
   end
   ok = true
   if (state0Isle == nil) then
      logFile:write("GetLargestIsles state0Isle not found\n")
      logFile:flush()
      ok = false
   elseif (state1Isle == nil) then
      logFile:write("GetLargestIsles state1Isle not found\n")
      logFile:flush()
      ok = false
   end
   -- U may all be one state
   local secomdIsle
   if (state1Isle  ~= nil) then
      secondIsle = state1Isle.multiLstNo
   end
   return ({state0Isle.multiLstNo, secondIsle})
end
-----------------------------------------------------------------------------------------------


local function dumpIslandData()
   logFile:write("\ndumpIslandData\n\n")
   local noOfIsles = 0
   local noOfOthroIlses = 0
   iLst = isleLstStart
   while (iLst) do
      noOfIsles = noOfIsles + 1
      logFile:write("Island "..iLst.isleNo.." State "..iLst.cellState
                     .." Embbeded "..iLst.embbedCnt.." DiagCocCnt "..iLst.diagConCnt.."\n")
      cLst = iLst.cellLst
      local cnt = 10
      local no = 0
      while (cLst) do
         logFile:write(" "..cLst.cellI..","..cLst.cellJ)
         cnt = cnt - 1
         no = no + 1
         if (cnt == 0) then
            logFile:write("\n")
            cnt = 10
         end
         cLst = cLst.next
      end
      logFile:write(" ("..no..")\n")
      iLst = iLst.next
   end
   
   iLst = isleLstStart
   while (iLst) do
      local mLst = iLst.MultiCellLst
      while (mLst) do
         noOfOthroIlses = noOfOthroIlses + 1
         logFile:write("Island Ortho Sub "..iLst.isleNo.."."..mLst.multiLstNo.." State "..iLst.cellState
                        .." Cells "..mLst.Cells.." Cells Changed "..mLst.CellsChanged
                        .." Embbeded "..iLst.embbedCnt.." DiagCocCnt "..iLst.diagConCnt.."\n")
         local cLst = mLst.cellLst
         local cnt = 10
         local no = 0
	 while (cLst) do
	     cnt = cnt - 1
             no = no + 1
             logFile:write(" "..cLst.cellI..","..cLst.cellJ)
             if (cellDicOrtho[tostring(cLst.cellI)..","..tostring(cLst.cellJ)] ~= mLst.multiLstNo) then
                if (cellDicOrtho[tostring(cLst.cellI)..","..tostring(cLst.cellJ)]) then
	           logFile:write("*"..cellDicOrtho[tostring(cLst.cellI)..","..tostring(cLst.cellJ)].."* ")
	        else
	           logFile:write("*nil* ")
	        end
             end
	     if (cnt == 0) then
	        logFile:write("\n")
	        cnt = 10
	     end
	     cLst = cLst.next
         end
         logFile:write(" ("..no..")\n")
         mLst = mLst.next
      end
      iLst = iLst.next
   end
   logFile:write("dumpIslandData isles "..noOfIsles.." orthIslse "..noOfOthroIlses.."\n")
   logFile:flush()
end
-----------------------------------------------------------------------------------------------

local function writeHeader(outFile)
   outFile:write("Type,RULE,GEO,WV,HV,SEED,GEN,"..
                 "IsleNo,State,Cells,CellsChg,NBcnt1,NBcnt2,NBcnt3,NBcnt4,EdLen"..
                 ",CellsEM\n")
   -- Type {Isle, IsleEm, IsleO, IsleOEm}
end
-----------------------------------------------------------------------------------------------

local function writeLine(outFile,Type, rule, geo, seed, gen, isleNo, state, cells, CellsChg, NBcnt,
                         EmddededCells)
   
   outFile:write(Type..","..rule..","..geo..","..m.wv..","..m.hv..","..seed..","..gen..","
               ..isleNo..","..state..","..cells..","..CellsChg)
   local edgelen = 0
   for i = 1,4 do
      outFile:write(","..NBcnt[i])
      edgelen = edgelen + i*NBcnt[i]
   end
   outFile:write(","..edgelen..","..EmddededCells.."\n")
end
   
-----------------------------------------------------------------------------------------------
local function writeIslandData(outFile, rule, geo, seed, gen)
   local stateA = -1
   local stateB = -1
   local islandNo = 1
   local lst = isleLstStart
   while(lst) do
      local NBcnt = {0,0,0,0}
      local NBcntOsum = {0,0,0,0}
      local cells = 0
      local cellsOsum = 0
      local tyEM = ""
      local CellsChanged = 0
      if (lst.embbeded) then
         tyEM = "Em"
      end
      if(stateA == -1) then
         stateA = lst.cellState
      else
         if ((stateB == -1) and (stateA ~= lst.cellState)) then
            stateB = lst.cellState
            logFile:flush()
         end
      end
      cLst = lst.cellLst
      while(cLst) do
         if (cLst.edgeCnt > 0) then
            NBcnt[cLst.edgeCnt] = NBcnt[cLst.edgeCnt] + 1
         end
         cells = cells + 1
         cLst=cLst.next
      end
      if ( lst.Cells ~= cells ) then
          logFile:write("*** writeIslandData island "..lst.isleNo.." missmatch cells "..lst.Cells.." found but "..cells.." counted\n")
      end
      local y = 0
      local mLst = lst.MultiCellLst
      local islandNoO = 1
      while (mLst) do
         local cellsO = 0
   	 local NBcntO = {0,0,0,0}
         local cLst = mLst.cellLst
         while (cLst) do
            if (cLst.edgeCnt > 0) then
               NBcntO[cLst.edgeCnt] = NBcntO[cLst.edgeCnt] + 1
            end
            cellsO = cellsO + 1
            cLst = cLst.next
         end
         if ( mLst.Cells ~= cellsO ) then
             logFile:write("*** writeIslandData island "..lst.isleNo.."."..islandNoO.." missmatch cells "..mLst.Cells.." found but "..cellsO.." counted\n")
         end
         CellsChanged = CellsChanged + mLst.CellsChanged
	 writeLine(outFile,"isleO"..tyEM, rule, geo, seed, gen, lst.isleNo.."."..islandNoO, lst.cellState, cellsO, mLst.CellsChanged, NBcntO, 0)
         islandNoO = islandNoO + 1
         cellsOsum = cellsOsum + cellsO
         for i = 1,4 do
            NBcntOsum[i] = NBcntOsum[i] + NBcntO[i]
         end
         mLst = mLst.next
      end
      
      writeLine(outFile,"Isle"..tyEM, rule, geo, seed, gen, lst.isleNo, lst.cellState, cells, CellsChanged, NBcnt,
                         lst.embbedCnt)
      islandNo = islandNo + 1
      lst= lst.next
   end
   return ({stateA, stateB})
end
-----------------------------------------------------------------------------------------------

function get_MaxIsle(state)   
   local lst = isleLstStart
   local best = 0
   local bestIsle = nil
   while(lst) do
      if (lst.cellState == state) then
         local tryThis = (lst.Cells > best) 
         if (tryThis) then
            best = lst.Cells
            bestIsle = lst
         end
      end
      lst = lst.next
   end
   if (bestIsle) then
      logFile:write("get_MaxIsle state "..state.." = "..bestIsle.isleNo.."\n")
   end
   return(bestIsle)
end
-----------------------------------------------------------------------------------------------

function get_isleCounts(state)
   local lst = isleLstStart
   local best = 0
   local totaltCells = 0
   local totalLsts = 0
   local bestIsle = lst
   local bestOrthos = 0
   local totalOrtho = 0
   local tryThis
   while(lst) do
      if (lst.cellState == state) then
         totaltCells = totaltCells + lst.Cells
         totalLsts = totalLsts + 1
         local tryThis = (lst.Cells > best) 
         if (tryThis) then
            best = lst.Cells
            bestIsle = lst
            bestOrthos = 0
         end
         local mLst = lst.MultiCellLst
         while (mLst) do
            totalOrtho = totalOrtho + 1
            if (tryThis) then
               bestOrthos = bestOrthos + 1
            end
            mLst = mLst.next
         end
      end
      lst = lst.next
   end
   return ({Cells = best,
            orhtoLsts = bestOrthos,
            totalCells = totaltCells, 
            totalIsles = totalLsts,
            totalOrthos = totalOrtho})
end
-----------------------------------------------------------------------------------------------

local function writeHalfHeader(outFile)
   outFile:write("RULE,GEO,WV,HV,SEED,GEN,MAXCELLS,NOORTHOISLES,ALLISLES,ALLORTHISLES\n")   
end
-----------------------------------------------------------------------------------------------

local function writeHalfData(outFile,rule, geo, seed, gen, stateLst)
   
   local resA = get_isleCounts( stateLst[1] )
   local resB = get_isleCounts( stateLst[2] )
   outFile:write(rule..","..geo..","..m.wv..","..m.hv..","..seed..","..gen..","
               ..resA.Cells..","..resA.orhtoLsts..","..resA.totalIsles..","..resA.totalOrthos.."\n")
   outFile:write(rule..","..geo..","..m.wv..","..m.hv..","..seed..","..gen..","
               ..resB.Cells..","..resB.orhtoLsts..","..resB.totalIsles..","..resB.totalOrthos.."\n")
end
-----------------------------------------------------------------------------------------------

function isle_cellScan(ip, jp, cellKey, lstCellstate, iLst)
   logFile:write("#isle_cellScan "..cellKey.." state "..lstCellstate.." iLst "..iLst.isleNo.."\n")
   local ipM1 = cellCoord(m.i0, m.i1, ip-1)
   local ipP1 = cellCoord(m.i0, m.i1, ip+1)
   local jpM1 = cellCoord(m.j0, m.j1, jp-1)
   local jpP1 = cellCoord(m.j0, m.j1, jp+1)
   local toDoLst = nil
   for ind,coods in pairs({{ipM1,jp,   'o'}, {ipP1,jp,   'o'}, {ip,jpM1,   'o'},  {ip,jpP1,   'o'}}) do
      local iu = coods[1]
      local ju = coods[2]
      local cellKeyIJ = iu..","..ju
      local cellState = g.getcell(iu,ju)
      if (not cellIsleNo[cellKeyIJ]) then
         if (cellState == lstCellstate) then
            isle_ListAddCell(iLst, iu, ju, cellState, NBcount(iu, ju, cellState))
            toDoLst = {next = toDoLst, ip=iu, jp=ju, cellKey = cellKeyIJ, cellState = cellState}
         else
            add2ScanDoLst(iu, ju, cellKeyIJ, cellState)
         end
      end
   end
   scanMap[cellKey] = lstCellstate
   while (toDoLst) do
      logFile:write("#isle_cellScan toDoLst "..toDoLst.cellKey.."\n")
      if (not scanMap[toDoLst.cellKey]) then
         isle_cellScan(toDoLst.ip, toDoLst.jp, toDoLst.cellKey, lstCellstate, iLst)   
      else
         logFile:write("#isle_cellScan toDoLst "..toDoLst.cellKey.."  already scanned\n")
      end
     toDoLst = toDoLst.next
   end
end
-----------------------------------------------------------------------------------------------
   
local function dumpmLst(mLst)
   logFile:write("dumpmLst ")
   if (mLst) then
      logFile:write(mLst.multiLstNo.."\n")
   else
      logFile:write("nil \n")
   end
   local mL = mLst
   while(mL) do
      logFile:write("->"..mL.multiLstNo)
      mL = mL.next
   end
   logFile:write("\n")
end
-----------------------------------------------------------------------------------------------
   
local function multiAddMultiLst(mLst1, Lst,  mLst2)
--   dumpmLst(mLst1)
--   dumpmLst(mLst2)
   if (mLst1 and mLst2) then
      --logFile:write("multiAddMultiLst Island "..Lst.isleNo.." mLst1 "..mLst1.multiLstNo.." mLst2 "..mLst2.multiLstNo.."\n")
      local clst2 = mLst2.cellLst
      local lastCell = clst2
      while (clst2) do
         cellDicOrtho[tostring(clst2.cellI)..","..tostring(clst2.cellJ)] = mLst1.multiLstNo
         lastCell = clst2
         clst2 = clst2.next
      end
      mLst1.Cells = mLst1.Cells + mLst2.Cells 
      lastCell.next = mLst1.cellLst
      mLst1.cellLst = mLst2.cellLst
      if (mLst2.prev) then
         mLst2.prev.next = mLst2.next
      else
         if (mLst2.next == nil) then
            logFile:write("*** multiAddMultiLst Island "..Lst.isleNo.." mLst2.next is nil\n")
            exit(1)
         end
         Lst.MultiCellLst = mLst2.next
      end
      if (mLst2.next) then
         mLst2.next.prev = mLst2.prev
      end
      muliLstDic[mLst2.multiLstNo]=nil
   else
      logFile:write("*** multiAddMultiLst nil mult List\n")
      if (mLst1) then
          logFile:write("*** multiAddMultiLst mLst1 OK "..mLst1.multiLstNo.."\n")
      end
      if (mLst2) then
          logFile:write("*** multiAddMultiLst mLst2 OK "..mLst2.multiLstNo.."\n")
      end
      logFile:flush()
   end
   return(mLst1)
end
-----------------------------------------------------------------------------------------------

local function FindDiagCon()
   logFile:write("FindDiagCon\n")
   logFile:flush()
   local isleLst = isleLstStart
   local MultiLstN0 = 0
   muliLstDic = {}
   while (isleLst) do
      --logFile:write(isleLst.isleNo.."\n")
      --logFile:flush()
      if (not isleLst.cellLst) then
         logFile:write("No Cells \n")
      end
      isleLst.MultiCellLst = nil
      local cLst = isleLst.cellLst
      local mOrhtLst = nil
      logFile:write("FindDiag isleLst "..isleLst.isleNo.."\n")
      while (cLst) do
         local cellKey = tostring(cLst.cellI)..","..tostring(cLst.cellJ)
         if (not cellDicOrtho[cellKey]) then
            MultiLstN0 = MultiLstN0 +1
            mOrhtLst = {next = isleLst.MultiCellLst, prev = nil, multiLstNo = MultiLstN0, Cells = 1, CellsChanged = 0,
                        cellLst = {next, cellI = cLst.cellI, cellJ = cLst.cellJ, edgeCnt = cLst.edgeCnt}}
            if (isleLst.MultiCellLst) then
               isleLst.MultiCellLst.prev = mOrhtLst
            end
	    cellDicOrtho[cellKey] = mOrhtLst.multiLstNo
            muliLstDic[mOrhtLst.multiLstNo] = mOrhtLst
            isleLst.MultiCellLst = mOrhtLst
         else
            mOrhtLst = muliLstDic[cellDicOrtho[cellKey]]
            mOrhtLst.edgeCnt = cLst.edgeCnt
            --logFile:write("FindDiag MultiLst Old "..mOrhtLst.multiLstNo..
            --              " cellKey "..cellKey.." cellDicOrtho["..cellKey.."] "..cellDicOrtho[cellKey].."\n")
         end
         local ipM1 = cellCoord(m.i0, m.i1, cLst.cellI-1)
         local ipP1 = cellCoord(m.i0, m.i1, cLst.cellI+1)
         local jpM1 = cellCoord(m.j0, m.j1, cLst.cellJ-1)
         local jpP1 = cellCoord(m.j0, m.j1, cLst.cellJ+1)
         local orthogCon = true
         for ind,coods in pairs({{ipM1,cLst.cellJ}, {ipP1,cLst.cellJ}, {cLst.cellI,jpM1},  {cLst.cellI,jpP1}}) do
            local iu = coods[1]
            local ju = coods[2]
            local cellkeyU = tostring(iu)..","..tostring(ju)
            if(cellIsleNo[cellkeyU] == isleLst.isleNo) then	--#2023-06-19##
               if (cellDicOrtho[cellkeyU]) then
                  if (cellDicOrtho[cellkeyU] ~= mOrhtLst.multiLstNo) then
                     mOrhtLst = multiAddMultiLst(muliLstDic[cellDicOrtho[cellkeyU]], isleLst, mOrhtLst)
                     muliLstDic[mOrhtLst.multiLstNo] = mOrhtLst
                  end
               else
                  mOrhtLst.cellLst = {next = mOrhtLst.cellLst , cellI = iu, cellJ = ju, edgeCnt = NBcount(iu, ju, isleLst.cellState)}
                  cellDicOrtho[cellkeyU] = mOrhtLst.multiLstNo
                  mOrhtLst.Cells = mOrhtLst.Cells + 1
                  orthogCon = true
               end                
            end
         end  
         cLst = cLst.next
      end
      isleLst = isleLst.next
   end
end
   
-----------------------------------------------------------------------------------------------
   
local function FindEmbeded()
-- Find the Number of cells of the other state embeded in this island

   logFile:write("FindEmbeded\n")
   logFile:flush()
   local maxIsles = {[0] = get_MaxIsle(0), [1] = get_MaxIsle(1), [2] = get_MaxIsle(2)}
   local isleLst = isleLstStart
   while (isleLst) do
      if (maxIsles[isleLst.cellState]) then
         logFile:write("FindEmbeded: cell state "..isleLst.cellState.." has max isle "..maxIsles[isleLst.cellState].isleNo.."\n")
      else
         logFile:write("*** FindEmbeded: cell state "..isleLst.cellState.." has no max isle \n")
      end
      if (isleLst ~= maxIsles[isleLst.cellState]) then
         local thisIsle = isleLst.isleNo
         local cellLst = isleLst.cellLst
         local otherIsle
         local embbeded = true
         local cellCnt = 0
         logFile:write("FindEmbeded isle "..thisIsle.."\n")
         logFile:flush()
         while (cellLst) do
            cellCnt = cellCnt + 1
            local ipM1 = cellCoord(m.i0, m.i1, cellLst.cellI-1)
         	 local ipP1 = cellCoord(m.i0, m.i1, cellLst.cellI+1)
         	 local jpM1 = cellCoord(m.j0, m.j1, cellLst.cellJ-1)
         	 local jpP1 = cellCoord(m.j0, m.j1, cellLst.cellJ+1)
         	 for ind,coods in pairs({{ipM1,cellLst.cellJ, 'o'}, {ipP1,cellLst.cellJ, 'o'}, {cellLst.cellI,jpM1, 'o'}, {cellLst.cellI,jpP1, 'o'},
         	                         {ipM1,jpM1, 'd'},          {ipP1,jpM1, 'd'},          {ipM1,jpP1, 'd'},          {ipP1,jpP1, 'p'}}) do
         	    local iu = coods[1]
               local ju = coods[2]
               local otherIsleU = cellIsleNo[tostring(iu)..","..tostring(ju)]	--#2023-06-19##
               if (otherIsleU ~= thisIsle) then
                  if(otherIsle == nil) then
                     otherIsle = otherIsleU
                  elseif(otherIsle ~= otherIsleU) then
                     embbeded = false
                     break
                  end
               end
            end
            cellLst = cellLst.next
         end
         isleLst.embbeded = embbeded and otherIsle
         if (isleLst.embbeded) then
            logFile:write("FindEmbeded: isle "..thisIsle.." state "..isleLst.cellState.." with "..cellCnt.." cells is embeded in "..otherIsle.."\n")
         end
      else
         logFile:write("FindEmbeded: isle "..isleLst.isleNo.." state "..isleLst.cellState.." with "..isleLst.Cells.." cells is max island\n")
      end
      isleLst =isleLst.next
   end
end
-----------------------------------------------------------------------------------------------

function CountChangedCells()
   local isleLst = isleLstStart
   while (isleLst) do
       local state = isleLst.cellState
       local mLst = isleLst.MultiCellLst
       while (mLst) do
          local changed = 0
          local cLst = mLst.cellLst
          while (cLst) do
             if (g.getcell(cLst.cellI, cLst.cellJ)  ~= state) then
                changed = changed + 1
             end
             cLst = cLst.next
          end
          mLst.CellsChanged = changed
          mLst = mLst.next
       end
      isleLst = isleLst.next
   end   
end
-----------------------------------------------------------------------------------------------

function stripAnalysis(logFileP, outFile, h)
   logFile:write("stripAnalysis\n")
   local largestIsles = GetLargestIsles()
   local allsCells = h.width * h.hight
   logFile:write("stripAnalysis "..h.rule.." largest islands "..largestIsles[1]..",muliLstDic size "..#muliLstDic.."\n")
   if (largestIsles[2]) then
      logFile:write("stripAnalysis "..h.rule.." largest island no "..muliLstDic[largestIsles[1]].multiLstNo..","..largestIsles[2].."\n")
   
      local perCent = (muliLstDic[largestIsles[1]].Cells + muliLstDic[largestIsles[2]].Cells)*100 /allsCells
      logFile:write("stripAnalysis muliLstDic[largestIsles[1]].Cells "..muliLstDic[largestIsles[1]].Cells.."\n")
      logFile:write("stripAnalysis muliLstDic[largestIsles[2]].Cells "..muliLstDic[largestIsles[2]].Cells.."\n")
      logFile:write("stripAnalysis allsCells"..allsCells.."\n")
      logFile:write("stripAnalysis "..h.rule.." largest islands percent "..perCent.."\n")
      logFile:write("stripAnalysis "..h.rule.." largest islands percent "..perCent.."\n")
      
      logFile:write("stripAnalysis "..h.rule.." largest islands percent "..perCent.."\n")
      if (perCent > 20) then
         outData = {}
         stripVD(outData, h, 'D', largestIsles)
         stripVD(outData, h, 'V', largestIsles)
         for i,line in pairs(outData) do
            h.stripFile:write(line) 
         end
      else
         logFile:write("*** stripAnalysis "..h.rule.."("..h.width..","..h.hight..") cells ..largest islands too small "..perCent.."\n")
         logFile:write("*** stripAnalysis cells "..muliLstDic[largestIsles[1]].Cells..","..muliLstDic[largestIsles[1]].Cells.."\n")
      end
  else 
     logFile:write("*** stripAnalysis Only one island\n")
  end 
end
-----------------------------------------------------------------------------------------------

function m.findIslands(logFileP)
   logFile = logFileP
   logFile:write("m.findIslands\n")
   init()
   local cellState = g.getcell(0,0)
   logFile:write("m.findIsland Stats initial state "..cellState.."\n")
   Isle_New(0, 0, "0,0", cellState, NBcount(0, 0, cellState))
   local changes = true
   while (changes) do
      changes = false
      for state,lst in pairs (scanDoLst) do
         logFile:write("#isle_cellScan check other state dolist "..state.."\n")
         local toDoLst =scanDoLst[state] 
         while (toDoLst) do
            scanDoLst[state] = toDoLst.next
   --         logFile:write("#isle_cellScan toDoLst "..toDoLst.cellKey.."\n")
            if (not cellIsleNo[toDoLst.cellKey]) then
               changes = true
               Isle_New(toDoLst.ip, toDoLst.jp, toDoLst.cellKey, toDoLst.cellState,
                        NBcount(toDoLst.ip, toDoLst.jp, toDoLst.cellState))
            end
            toDoLst = scanDoLst[state]
         end
      end
   end
end
-----------------------------------------------------------------------------------------------

function m.ShowIslands()
   gt.SetupTrace()
   local largest = Isle_GetLargest()
   for state,v in pairs(largest) do
      gt.DisplayIsland(largest[state].isle, state)
   end
   dumpIslandData()
end
-----------------------------------------------------------------------------------------------

function m.ShowIsland_n(isleNo)
   local iLst = isleLstStart
   while (iLst) do
      if (iLst.isleNo == isleNo) then
         gt.DisplayIsland(iLst, 3)
         break
      end
      iLst = iLst.next
   end
end
-----------------------------------------------------------------------------------------------

function m.AllIslandStats()
   local txt = ""
   local count = 0
   local allSize = 0
   local iLst = isleLstStart
   while (iLst) do
      count = count + 1
      txt = txt..count.." state "..iLst.cellState.." "..iLst.Cells.." cells\n"
      allSize = allSize + iLst.Cells
      iLst = iLst.next
   end
   txt = txt.."cells in islands "..allSize.." leaving "..((g.getwidth() * g.getheight()) - allSize).." cells\n"
   return(txt)
end
-----------------------------------------------------------------------------------------------

function m.BigIslandStats()
-- size of 2 bigest islands
-- no of other islands
-- cell count of other islands
   local bigestSize = {}
   local otherSize = 0
   local otherCount = 0
   local nonSize = 0
   local largest = Isle_GetLargest()
   local size = 0
   local txt = ""
   for state,v in pairs(largest) do
      bigestSize[state] = largest[state].isle.Cells
      txt = txt.."Bigest state "..state.." island size is "..bigestSize[state].."\n"
      size = size + bigestSize[state]
      otherCount = otherCount -1
   end
   otherSize = -size
   local iLst = isleLstStart
   while (iLst) do
      otherCount = otherCount + 1
      otherSize = otherSize + iLst.Cells
      iLst = iLst.next
   end
   txt = txt.."Number of Other Islands "..otherCount.." with "..otherSize.." cells\n"
   otherSize = (g.getwidth() * g.getheight()) - size
   return (txt)
end
-----------------------------------------------------------------------------------------------

function m.findIslandStats(logFileP, outFile, halfFile, h)
   logFile = logFileP   
   logFile:write("m.findIslandStats\n")
   m.ShowIslands()
   dumpIslandData()
   logFile:write("m.findIsland created, next FindEmbeded\n")
   logFile:flush()
   FindEmbeded()
   FindDiagCon()
   stripAnalysis(logFileP, outFile, h)
   g.run(1)
   g.update()
   CountChangedCells()
   dumpIslandData()
   if (h.rule == "H--") then
      writeHeader(outFile)
   end
   stateLst = writeIslandData(outFile, h.rule, h.geo, h.seed, h.gen+1)
   if (halfFile) then
      writeHalfData(halfFile, h.rule, h.geo, h.seed, h.gen+1, stateLst)
      halfFile:flush()
   end
   outFile:flush()
   logFile:flush()
end

--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      m.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = "D"
   end
   return true
end
--==============================================================================
------------------------------------------------------------
-- If a run is interruppted then the last seed run can be ignored as it will be incomplete.
-- 
local function openOutFile()
   local s = {}
   local lastSeedRun = {}
   local lastSeedRunKey = ''
   local outData = {}
   local inFile, outFile, line, words, key, keyFound, noLines
   local outFileOpen = false
   s.linesDone = {}
   if scriptFileData then
      inFile = io.open ( scriptFileData.RESULTS_NEW , "r")
      if inFile and scriptFileData.RESULTS_OLD then         
         outFile = io.open ( scriptFileData.RESULTS_OLD , "w")
         if outFile then
            line = inFile:read("*l")
            while line do
               if not line:upper():find("RULE") then
                  outFile:write(line..'\n')
               end
               line = inFile:read("*l")
            end
            inFile:close()
            outFile:close()
            s.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
            writeHeader(s.outFile)
            outFileOpen = true
            inFile = io.open ( scriptFileData.RESULTS_OLD , "r")
            if s.outFile and inFile then
               line = inFile:read("*l")
               keyFound = false
               while line do
                  if not line:upper():find("RULE") then
                     words = split(line)

                     if (#words == 16) then   --  1 Type 2 RULE,    3 GEO,     4 WV,     5 HV,      6 SEED, 7 GEN, 8 ISLANDNO, 9 State, 10 SIZE,
                                              -- 11 NBcnt1, 12 NBcnt2, 13 NBcnt3, 14 NBcnt4, 15 EdgeLen 16 CellsEM.
                        key = words[1]..':'..words[2]..':'..words[3]..':'..words[4]..':'..words[5]..':'..words[6]
                        if (key ~= lastSeedRunKey) then
                           for i = 1, #lastSeedRun do
                              s.outFile:write(lastSeedRun[i]..'\n')
                           end
                           s.linesDone[lastSeedRunKey] = true
                           lastSeedRun = {}
                           lastSeedRunKey = key
                        end
                        lastSeedRun[#lastSeedRun+1] = line
                     else
                        logFile:write('*** openOutFile line '..line..' not 16 words\n')
                     end
                  end
                  line = inFile:read("*l")
               end
            else
               logFile:write("*** openOutFile (2nd) files not open infile:"..m.util.bool2txt(inFile).." outfile:"..m.util.bool2txt(m.outFile).."\n")
               s.outFile:close()
               outFileOpen = false
            end
         else
            comProcs.showTextOV('Failed to input output file '..scriptFileData.RESULTS_NEW)
            logFile:write('*** Failed to open input file '.."scriptFileData.RESULTS_NEW\n")
         end
      end
      if inFile then
         inFile:close()
      end
      if not outFileOpen then
         s.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
         writeHeader(s.outFile)
      end
      if not s.outFile then
         comProcs.showTextOV('Failed to open output file '..scriptFileData.RESULTS_NEW)
         logFile:write('*** Failed to open input file '.."scriptFileData.RESULTS_NEW\n")
      end
   else
      comProcs.showTextOV('No Script file Loaded')
   end
   return(s)
end
------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('*** Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end


------------------------------------------------------------
local function maxState(ip,jp)
   local s0 = 0
   local s1 = 0
   for i = ip-1, ip+1, 1 do
      for j = jp-1,jp+1, 1 do
         if (g.getcell(cellCoord(m.i0,m.i1,i), cellCoord(m.j0,m.j1,j)) == 1) then
            s0 = s0 + 1
         else
            s1 = s1 + 1
         end
      end
   end
   
   if (s0 > s1) then
      return(1)
   else
      return(2)
   end
end

------------------------------------------------------------
function m.islandLayer(logFileP)
   init()
   if (g.getlayer() == 1) then
      g.setlayer(0)
      return
   end
   logFile = logFileP
   logFile:write("m.islandLayer\n")
   local newState
   while g.numlayers() > 1 do
      g.setlayer(1)
      g.dellayer()
   end
   g.setlayer(0)
   local dupeindex = g.duplicate()
   g.setlayer(0)
   for i = m.i0, m.i1 do
      for j = m.j0, m.j1 do
         newState = maxState(i,j)
         g.setlayer(dupeindex)
         g.setcell(i, j, newState)
         g.setlayer(0)
      end
   end
   g.setlayer(dupeindex)
   logFile:flush()
end

------------------------------------------------------------
------------------------------------------------------------
function m.run(segmentNo)

   ---------------------  script data-----------------------
   --  RULES: GEO=,  WIDTH =,  HIGHT =, DO=ISLAND
   --  SEEDS: GEN =, STEP =,   COUNT=
   --  STEP1 = ,    STRIPLENG = 60,    CELL_X = 0, CELL_Y = 0, RESULTS_STRIP:  for strip anlaysis
   ---------------------------------------------------------
   g.show('Island Analysis Started')
   logFile:write('\nIsland Analysis Started\n')
   
   m.island(segmentNo)
end

------------------------------------------------------------
function m.island(segmentNo)
   local rule, seed, state, newState, gen, outData, outFile, inFile, halfFile
   local started = false
   local s, wv, hv
   local startTime = os.clock()
   local h = {}
   g.show("Script Run Length")
   
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      comProcs.LogScript(segmentNo)
      s = openOutFile()
      local geoList = {'D','O'}
      if scriptFileData.GEO ~= 'B' then
         geoList = {scriptFileData.GEO}
      end
      wv = scriptFileData.WIDTH
      hv = scriptFileData.HIGHT
      h.width = wv
      h.hight = hv
      h.x = scriptFileData.CELL_X
      h.y = scriptFileData.CELL_Y
      h.stripFile = io.open ( scriptFileData.RESULTS_STRIP , "w")
      h.stripFile:write("RULE,GEO,WIDTH,SEED,STRIPDIR,START_X,START_Y,GEN,DIST,RUNLENG\n")
      logFile:write('Island get files\n')
      if s.outFile then
         logFile:write("scriptFileData.RESULTS_NEW "..scriptFileData.RESULTS_NEW.."\n")
         if (scriptFileData.RESULTS_HALF) then
            logFile:write("scriptFileData.RESULTS_HALF "..scriptFileData.RESULTS_HALF.."\n")
            logFile:flush()
            halfFile = io.open ( scriptFileData.RESULTS_HALF , "w")
            writeHalfHeader(halfFile)
         else
            halfFile = nil
         end
         logFile:write('Island files OK\n')
         for i1,rule in pairs(scriptFileData.RULES) do
            g.new('SymCACP Script '..scriptFileData.RESULTS_NEW..' '..rule..' ')
            h.rule = rule
            for i2,seed in pairs(scriptFileData.SEEDS) do
               h.seed = seed
               g.show("seed "..seed)
               for i3,geo in pairs(geoList) do
                  h.geo = geo:sub(1,2)
                  key = rule..':'..geo..':'..wv..':'..hv..':'..seed
                  if (not s.linesDone[key]) then
                     gr.doBuild(' SymCACP Island ', wv, hv, seed, geo, rule)  -- w, h, seed, rule, format
                     g.show("GEN "..scriptFileData.GEN)
                     gen = scriptFileData.GEN-scriptFileData.STEP
                     logFile:write('Built OK\n')
                     g.run(gen)
                     logFile:write('Run '..gen..' gens\n')
                     started = false
                     for iVal = 1, scriptFileData.COUNT do
                        g.run(scriptFileData.STEP)
                        g.update()
                        gen = tonumber(g.getgen())
                        logFile:write('Run step'..scriptFileData.STEP..' gens\n')
                        h.gen = gen
                        m.findIslands(logFile)
                        m.findIslandStats(logFile, s.outFile, halfFile, h)
                     end
                  end
               end
            end
         end
         s.outFile:close()
         if (halfFile) then
            halfFile:close()
         end
         if (h.stripFile) then
	    h.stripFile:close()
         end
      end
      local elapsed = os.clock()-startTime
      local elHrs = math.floor(elapsed/3600)
      local elMins = math.floor((elapsed-elHrs*3600)/60)
      local elSecs = (elapsed-elHrs*3600-elMins*60)   
      logFile:write(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
      g.show(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
      if logDiverted then
         logFile:flush()
         reDivertLog()
      end
   else
      comProcs.showTextOV('No Script file Loaded')
   end
end
--==============================================================================
------------------------------------------------------------------------------------------------

return m
------------------------------------------------------------
